'use strict'

entityRegistry['module']['greetsArrows'] = {
    extendedInfo: {
        displayName: 'Greets Arrows',
        displayGroup: '3D Effects',
    },
    init: (staticConfig) => {
        const {
            arrowSeed,
            segments,
            numArrows
        } = { ...staticConfig }

        const rng = new Math.seedrandom(arrowSeed)
        const arrows = []
        const fwd = [1,0,0]
        for (let i = 0; i < numArrows; ++i) {
            const points = []
            const xOff = rng()*-20-2
            const yOff = (rng()-.5)*5
            const zOff = 2-rng()*10
            for (let j = 0; j < 100; ++j) {
                let p = m4.multiplyVector(fwd, -5 + j*2.5 + j*i*.1)
                p[0] += (rng()-.5)*.5+xOff
                p[1] += (rng()-.5)*.5+yOff
                p[2] += (rng()-.5)*.5+zOff
                points.push(p)
            }
            const first = points[0]
            first[0]+=0.001
            points.unshift(first)
            const splinePoints = pathToSpline(points, segments)
            arrows.push(new ArrowModel(splinePoints))
        }

        return {
            arrows
        }
    },
    staticConfig: [
        { paramName: 'arrowSeed', displayName: 'Arrow Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'arrowSegments', displayName: 'Arrow Segments', type: 'int', defaultValue: 50, triggerInit: true },
        { paramName: 'numArrows', displayName: 'Arrows', type: 'int', defaultValue: 10, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'arrowAnimation', displayName: 'Arrow Animation', type: 'float', defaultValue: 0},
        { paramName: 'arrowLength', displayName: 'Arrow Length', type: 'float', defaultValue: 20},
        { paramName: 'arrowWidth', displayName: 'Arrow Width', type: 'float', defaultValue: 1},
        { paramName: 'arrowDepth', displayName: 'Arrow Depth', type: 'float', defaultValue: 1},
        { paramName: 'arrowHead', displayName: 'Arrow Head', type: 'float', defaultValue: 1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                arrowAnimation,
                arrowLength,
                arrowWidth,
                arrowDepth,
                arrowHead,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const worldMat = m4.identity()

            const animationPos = arrowAnimation
            let c = 0
            self.arrows.forEach(arrow => {
                arrow.reset()
                const start = Math.max(0, animationPos-arrowLength)
                // arrow.addObject(c, Math.max(start-10, 0), Math.max(start-5, 0),
                //     (a,t) => .2,//Math.sin(c+t*84)*.1+.12,
                //     (a,t) => .2,//Math.sin(c+t*54)*.1+.12,
                // )
                arrow.addObject(c, start, animationPos,
                    (a,t) => arrowDepth,
                    (a,t) => arrowWidth,
                    true, arrowDepth, arrowHead, 1
                )
                c++
                renderer.drawModel(arrow.getModel(), worldMat, colorBuffer, depthBuffer, brightnessBuffer)
            })
        }
    }
}
